﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderIndividualHpiiDelete]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[HealthProviderIndividualHpiiDelete]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================

-- Create date:   07/10/2015
-- Description:   Delete a HPII for a Health Provider Individual
-- =============================================

CREATE PROCEDURE [hips].[HealthProviderIndividualHpiiDelete]
(
	@HealthProviderIndividualId INT
)
AS
BEGIN
	
	SET NOCOUNT ON

    DECLARE @ErrorCode INT,
			@RowsAffected INT
	
	DELETE 
	FROM [hips].HealthProviderIndividualHpii 
	WHERE HealthProviderIndividualId = @HealthProviderIndividualId
	
	SELECT	@ErrorCode = @@ERROR,
			@RowsAffected = @@ROWCOUNT

	SELECT @RowsAffected AS RowsAffected

    RETURN(@ErrorCode)
	
END
GO
